function GraySpriteSet(filename)
{
	var ss = LoadSpriteset(filename+".rss")
	var temp_sur;
		
	for (gs = 0; gs < ss.images.length; gs++)
	{
		temp_sur = ss.images[gs].createSurface();
		temp_sur.setBlendMode(REPLACE);
			
		for (sxi = 0; sxi<temp_sur.width;sxi++)
		{
			for (syi = 0; syi<temp_sur.height;syi++)
			{
				pixel = temp_sur.getPixel(sxi,syi);
				val = Math.floor(pixel.red+pixel.green+pixel.blue)/3;
				temp_sur.setPixel(sxi,syi, CreateColor(val,val,val, pixel.alpha));
			}
		}
		ss.images[gs] = temp_sur.createImage();
	}
	ss.save("gray/g_"+filename+".rss");
}
	
function GrayScaleSpriteSets()
{
	GraySpriteSet("enemy1_legs");
	GraySpriteSet("enemy1_arm1");
	GraySpriteSet("enemy1_arm2");

	GraySpriteSet("enemy2_legs");
	GraySpriteSet("enemy2_arm1");
	GraySpriteSet("enemy2_arm2");

	GraySpriteSet("eye1_legs");
	GraySpriteSet("eye1_arm1");
	GraySpriteSet("eye1_arm2");


	GraySpriteSet("door1");
	GraySpriteSet("door1b");
	GraySpriteSet("door2");
	GraySpriteSet("door3");
	GraySpriteSet("door4");
	GraySpriteSet("door5");

	GraySpriteSet("explode1");
	GraySpriteSet("grenades");
	GraySpriteSet("guts1");
	GraySpriteSet("head");
	GraySpriteSet("heart");

	GraySpriteSet("jellyfish1_legs");
	GraySpriteSet("locker1");
	GraySpriteSet("locker2");
	GraySpriteSet("locker3");

	GraySpriteSet("mantis_legs");
	GraySpriteSet("mantis_arm1");
	GraySpriteSet("mantis_arm2");
	
	GraySpriteSet("shells");
	GraySpriteSet("wipe");

	GraySpriteSet("guard_legs");
	GraySpriteSet("umberdog");

	GraySpriteSet("terminal1");
	GraySpriteSet("wavebeam");

	GraySpriteSet("wavebeam");


	GraySpriteSet("sword_swing1");
	GraySpriteSet("gun2");
	GraySpriteSet("liegh_gun1");
	GraySpriteSet("liegh_type2");
	GraySpriteSet("liegh_type3");
	GraySpriteSet("liegh_type4");
	GraySpriteSet("liegh_type5");
	GraySpriteSet("liegh_type6");
	GraySpriteSet("liegh_type7");
	GraySpriteSet("liegh_type7b");
	GraySpriteSet("liegh_sword2");
	GraySpriteSet("liegh_legs");

	GraySpriteSet("guard_legs");
	GraySpriteSet("drone1_legs");
	GraySpriteSet("drone1_arms");
	GraySpriteSet("id_legs");
	GraySpriteSet("id_arm1");
	//GrayScaleMap();
}
	
//GrayScaleSpriteSets();
	
	
function GrayScaleMap()
{
	SetDefaultMapScript(SCRIPT_ON_ENTER_MAP, "GrayScaleMap2();");
	MapEngine("level17.rmp", 96);
}

function GrayScaleMap2()
{
	var temp_sur;
	var pixel;
	var val;

	var time = GetTime();

	for (sfi=162;sfi<2452;sfi++)
	{
		temp_sur = GetTileImage(sfi).createSurface();
		temp_sur.setBlendMode(REPLACE);
		
		for (sxi = 0; sxi<16;sxi++)
		{
			for (syi = 0; syi<16;syi++)
			{
				pixel = temp_sur.getPixel(sxi,syi);
				val = Math.floor(pixel.red+pixel.green+pixel.blue)/3;
				temp_sur.setPixel(sxi,syi, CreateColor(val,val,val, pixel.alpha));
			}
		}
		SetTileImage(sfi, temp_sur.createImage());
		if (sfi == 162)
			sfi = 174;
			
		if (sfi == 1984)
			sfi = 2416;
	}



	var mapy = GetMapEngine()
	
	mapy.save("level17_g.rmp");
	Exit();

}



// opengl driver converting



function OpenGLSpriteSet(filename)
{
	var ss = LoadSpriteset(filename)
	var tempy_surr;
	var temp_sur;
	
	var new_x, new_y;
	var dx = 0;
		
	for (gs = 0; gs < ss.images.length; gs++)
	{
		new_x = Math.pow(2,Math.ceil(Math.log(ss.images[gs].width)/Math.log(2)));
		new_y = Math.pow(2,Math.ceil(Math.log(ss.images[gs].height)/Math.log(2)));
	
		dx = Math.floor((new_x-ss.images[gs].width)/2);
	
		temp_sur = CreateSurface(new_x,new_y, CreateColor(0,0,0,0));
		temp_sur.setBlendMode(REPLACE);
		tempy_surr = (ss.images[gs]).createSurface();
		temp_sur.blitSurface(tempy_surr,dx,0);

			
		ss.images[gs] = temp_sur.createImage();
	}


	var basey = ss.base;
	
	basey.x1 = 0;
	basey.x2 += dx;
	
	ss.base = basey;

	ss.save("opengl/"+filename);
}


OpenGLSpriteSet("id.rss");
